﻿/* INTERFACE ENTRE OPEN RAILS ET UNE CARTE ARDUINO                                              Le 18/01/2026.
 Site Web : https://www.la-tour.info/uts/uts_page15.html
 Forum Web : https://www.rmf-magazine.com/phpBB/ > Section : Informatique, logiciels, trains virtuels.

 On va chercher les valeurs d'Open Rails, sur son serveur web : http://localhost:2150/API/CABCONTROLS
 If faut renseigner le fichier : "InterfaceORArduinoJLF_config.txt".

C'est un logiciel libre : liberté d’exécuter le programme, pour tous les usages. liberté d’étudier le fonctionnement du programme et de l’adapter à ses besoins.
liberté de redistribuer des copies. liberté d’améliorer le programme et de publier les améliorations.

 Le fichier de type : X:\Train Simulator MSTS\TRAINS\TRAINSET\common.cab\BB22200_V1\BB22200_15kv_P1_ana.cvf, contient les variables à envoyer.
 Exemple pour la variable "SPEEDOMETER" :
	Gauge (
		Type ( SPEEDOMETER GAUGE )
		Style ( POINTER )
		ScaleRange ( 0 160 )
		ZeroPos ( 0 )
		Units ( KM_PER_HOUR )
	)
Si plusieurs variables ont le même nom "SPEEDOMETER", on va en acquerir plusieurs sur ce serveur Web.
Exemple :
    { "TypeName": "SPEEDOMETER", "MinValue": 0.0, "MaxValue": 160.0, "RangeFraction": 0.0 },
    { "TypeName": "SPEEDOMETER", "MinValue": 0.0, "MaxValue": 999999.0, "RangeFraction": 0.0 },
    { "TypeName": "SPEEDOMETER", "MinValue": 136.0, "MaxValue": 296.0, "RangeFraction": 0.0 },
    { "TypeName": "SPEEDOMETER", "MinValue": 36.0, "MaxValue": 196.0, "RangeFraction": 0.0 },

/!\ Dans ce programme, si l'on reçoit plusieurs variables identiques, on ne conservera qu'une seule variable à envoyer.
    Dans ce cas, il faudra reprendre le fichier " Locomotive.cvf", en différenciant les nom des variables.
    On peut aussi positionner "nomavecmaxi = oui", pour ajouter la valeur "MaxValue" à la fin du nom de variable.
    Exemple : "SPEEDOMETER_160".  Avec MaxValue = 160 à la fin du nom. Ca améliore la différentiation des variables au nom identique.

En mode automatique, pour que la carte Arduino Open Rails soit reconnue, il faut que lorsqu'elle reçoit la chaine "<   :JLF?:0>", elle réponde par "<JLF!>".
Les données sont envoyées à la carte Arduino sous la forme :"<  :BRAKE_PIPE_200.0: 0.3381>".
C'est aussi le format utilisé par DTG Train Simulator Classic et le programme d'interface : TSClassic Raildriver and Joystick Interface V3.3.0.7.
Les données sont envoyées uniquement, si elles changent de valeur.

Contenu du fichier de configuration : "InterfaceORArduinoJLF_config.txt".
* ------------------------------------------------------------------------------------------------------------------------------------------
port = auto
* port = Port de l'Arduino. Si "auto", on cherche un Arduino qui répond "<JLF!>" à l'envoi de "<   :JLF?:0>". Par défaut = auto.
* port = Sinon, on donne le nom du port dédié à l'Arduino Open Rails.
* port = COM01, COM22, COM45, auto
* ------------------------------------------------------------------------------------------------------------------------------------------

vitesse = 38400
* vitesse = Débit en baud de la liaison avec la carte Arduino Open Rails. Par défaut = 38400.
* vitesse = 2400, 4800, 9600, 14400, 19200, 38400, 57600, 115200, 230400, 460800
* ------------------------------------------------------------------------------------------------------------------------------------------

precision = 3
* precision = Précision sur les valeurs transmises à l'Arduino. Nombre de chiffre après la virgule, 2="0,51"=1%,   3="0,514"=0,1%,   4="0,5148"=0,01%. Par défaut = 3.
* precision = Eviter > 4, car certaines variables sont instables, et si elles changent souvent de valeurs, elles sont transmises à chaque fois à l'Arduino.
* precision = En pratique prendre 3 pour avoir suffisamment de précision. On peut afficher 380 km/h sans soucis.
* precision = 2 à 8
* ------------------------------------------------------------------------------------------------------------------------------------------

timer = 200
* timer = Intervalle en milli secondes entre deux lectures de la page web d'Open Rails. Par défaut = 500 (2 fois par seconde), mais 200 fonctionne bien.
* timer = 50 à 5000
* ------------------------------------------------------------------------------------------------------------------------------------------

nomavecmaxi = oui
* nomavecmaxi = Le programme reçoit plusieurs variables de noms identiques, et ne conservera qu'une seule variable à envoyer.     Par défaut = oui.
* nomavecmaxi = Dans ce cas, il faudra reprendre le fichier " Locomotive.cvf", en différenciant les noms des variables.
* nomavecmaxi = Si "oui" => Dans ce cas le programme ajoute la valeur "MaxValue" à la fin du nom de variable.
* nomavecmaxi = Exemple : "SPEEDOMETER_160", avec MaxValue = 160 à la fin du nom. Ca améliore la différentiation des variables au nom identique.
* nomavecmaxi = oui, non
* ------------------------------------------------------------------------------------------------------------------------------------------
        
optimisation = oui
* optimisation = Le programme prend 1 % du cpu pour afficher les variables sur la fenêtre.      Par défaut = non.
* optimisation = C'est surtout sensible si "timer" < 500.
* optimisation = Si l'on indique "oui", le programme d'affichera plus les variables au bout de 1 mn.
* optimisation = oui, non* 
*/

using System;
using System.Windows.Forms;

namespace InterfaceORArduinoJLF
{
    internal static class Program
    {
        [STAThread]
        static void Main()
        {
            Application.EnableVisualStyles();
            Application.SetCompatibleTextRenderingDefault(false);
            Application.Run(new Form1());
        }
    }
}
/*  REMARQUES :
Ne pas oublier de configurer les évènements pour FORM1 :
   - Go to Designer > Right Click form > Properties > Events > Check if Form1_Load is available next to Load.
   - Timer : Ajouter Timer1 + propriétés > Timer = Timer1_tick.  */